<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-09-04
 ******************************************************************************/

namespace Fastmag\Sync\Ui\Component\Listing\Column\Customer;

use Magento\Ui\Component\Listing\Columns\Column;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;

/**
 * Class Action
 *
 * Column renderer for customer synchronized action
 */
class Action extends Column
{
    /** @var UrlInterface $urlBuilder */
    protected $urlBuilder;

    /**
     * Action constructor
     *
     * @param ContextInterface   $context
     * @param UiComponentFactory $uiComponentFactory
     * @param UrlInterface       $urlBuilder
     * @param array              $components
     * @param array              $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        UrlInterface $urlBuilder,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);

        $this->urlBuilder = $urlBuilder;
    }

    /**
     * @inheritDoc
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $item[$this->getData('name')]['delete'] = [
                    'href' => $this->urlBuilder->getUrl(
                        'fastmagsync/customer/delete',
                        ['id' => $item['sync_id']]
                    ),
                    'label' => __('Delete the matching'),
                    'confirm' => [
                        'title' => __('Are you sure?'),
                        'message' => __(
                            'Delete this matching won\'t delete the customer on Magento or Fastmag,'
                            . ' only the matching between the two.'
                            . ' It may block future synchronizations of this customer.'
                        ),
                    ],
                    'post'  => true
                ];
            }
        }

        return $dataSource;
    }
}
