<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-19
 ******************************************************************************/

namespace Fastmag\Sync\Model;

/**
 * Class DataPersistor
 *
 * Class storing data temporarily, as the Registry used to do in Magento 1
 */
class DataPersistor
{
    /** @var array $data */
    protected $data;

    /**
     * Store data by key
     *
     * @param string $key
     * @param mixed $data
     *
     * @return void
     */
    public function set($key, $data)
    {
        $this->data[$key] = $data;
    }

    /**
     * Retrieve data by key
     *
     * @param string $key
     *
     * @return null|mixed
     */
    public function get($key)
    {
        return $this->data[$key] ?? null;
    }

    /**
     * Clear data by key
     *
     * @param string $key
     *
     * @return void
     */
    public function clear($key)
    {
        unset($this->data[$key]);
    }
}
