<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-01-13
 ******************************************************************************/

namespace Fastmag\Sync\Setup\Patch\Data;

use Fastmag\Sync\Api\Data\Rule\OrdertransactionInterface as OrderTransactionRule;
use Fastmag\Sync\Api\Data\Rule\OrdertransactionInterfaceFactory as OrderTransactionRuleFactory;
use Fastmag\Sync\Api\Rule\OrdertransactionRepositoryInterface as OrderTransactionRuleRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Magento\Catalog\Model\ProductFactory;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchRevertableInterface;
use Magento\Sales\Model\Order;

/**
 * Class InstallDefaultConfig
 *
 * Installer for specific default configs
 *
 * @SuppressWarnings(PHPMD.LongVariable)
 */
class InstallDefaultConfig implements DataPatchInterface, PatchRevertableInterface
{
    protected ProductFactory $productFactory;
    protected WriterInterface $configWriter;
    protected OrderTransactionRuleRepository $orderTransactionRuleRepository;
    protected OrderTransactionRuleFactory $orderTransactionRuleFactory;
    protected Logger $logger;

    /**
     * InstallDefaultConfig constructor
     *
     * @param ProductFactory                 $productFactory
     * @param WriterInterface                $configWriter
     * @param OrderTransactionRuleRepository $orderTransactionRuleRepository
     * @param OrderTransactionRuleFactory    $orderTransactionRuleFactory
     * @param Logger                         $logger
     */
    public function __construct(
        ProductFactory                 $productFactory,
        WriterInterface                $configWriter,
        OrderTransactionRuleRepository $orderTransactionRuleRepository,
        OrderTransactionRuleFactory    $orderTransactionRuleFactory,
        Logger                         $logger
    ) {
        $this->productFactory = $productFactory;
        $this->configWriter = $configWriter;
        $this->orderTransactionRuleRepository = $orderTransactionRuleRepository;
        $this->orderTransactionRuleFactory = $orderTransactionRuleFactory;
        $this->logger = $logger;
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @inheritDoc
     */
    public function apply()
    {
        $defaultAttributeSetId = $this->productFactory->create()->getDefaultAttributeSetId();
        $this->configWriter->save(Config::XML_PATH_PRODUCT_IMPORT_ATTRIBUTE_SET_ID, $defaultAttributeSetId);

        $orderTransactionDefaultRule = $this->orderTransactionRuleFactory->create();
        $orderTransactionDefaultRule->setOrderStatus(Order::STATE_PROCESSING)
            ->setTransactionType(OrderTransactionRule::FASTMAG_TRANSACTION_TYPE_SALE)
            ->setPaymentMethod('*');

        try {
            $this->orderTransactionRuleRepository->save($orderTransactionDefaultRule);
        } catch (CouldNotSaveException $exception) {
            $this->logger->error(__('Unable to create default Order/Transaction rule'));
        }
    }

    /**
     * @inheritDoc
     */
    public function revert()
    {
        $this->configWriter->delete(Config::XML_PATH_PRODUCT_IMPORT_ATTRIBUTE_SET_ID);
    }
}
