<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-12-02
 ******************************************************************************/

namespace Fastmag\Sync\Api\Jobqueue;

use Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Interface ToMagentoRepositoryInterface
 */
interface ToMagentoRepositoryInterface
{
    /**
     * Save job.
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface $job
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(ToMagentoInterface $job);

    /**
     * Retrieve job.
     *
     * @param int $jobId
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($jobId);

    /**
     * Retrieve job by unique key (content_id, job_code, priority).
     *
     * @param int $contentId
     * @param string $jobCode
     * @param int $priority
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getByUniqueKey($contentId, $jobCode, $priority);

    /**
     * Retrieve jobs matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoSearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Retrieve jobs matching the specified criteria and group by priority and job_code.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @param int                                            $limit
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoSearchResultsInterface[]
     */
    public function getListByPriorityAndCode(SearchCriteriaInterface $searchCriteria, $limit);

    /**
     * Delete job.
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface $job
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(ToMagentoInterface $job);

    /**
     * Delete job by ID.
     *
     * @param int $jobId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($jobId);

    /**
     * Reset job
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface $job
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function reset(ToMagentoInterface $job);

    /**
     * Hydrate job with entity
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface $job
     * @param \Fastmag\Sync\Process\EntityInterface              $entity
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function hydrate(ToMagentoInterface $job, \Fastmag\Sync\Process\EntityInterface $entity);

    /**
     * Validate job
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface $job
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function validate(ToMagentoInterface $job);

    /**
     * Invalidate job
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface $job
     * @param \Exception $exception
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function invalidate(ToMagentoInterface $job, \Exception $exception);

    /**
     * Skip job
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface $job
     * @param \Exception $exception
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function skip(ToMagentoInterface $job, \Exception $exception);
}
