<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-01-02
 ******************************************************************************/

namespace Fastmag\Sync\Block\Adminhtml\Product\Edit\Button;

use Magento\Backend\Block\Widget\Context;
use Magento\Catalog\Api\Data\ProductInterface as Product;
use Magento\Catalog\Api\ProductRepositoryInterface as ProductRepository;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

/**
 * Class Resync
 *
 * Class for the button of product resync
 */
class Resync implements ButtonProviderInterface
{
    protected Context $context;
    protected ProductRepository $productRepository;

    /** @var Product $currentProduct */
    protected $currentProduct;

    /**
     * Generic constructor
     *
     * @param Context $context
     * @param ProductRepository $productRepository
     */
    public function __construct(Context $context, ProductRepository $productRepository)
    {
        $this->context = $context;
        $this->productRepository = $productRepository;
    }

    /**
     * @inheritDoc
     */
    public function getButtonData()
    {
        return [
            'label'      => __('Resync with Fastmag'),
            'on_click'   => sprintf("location.href = '%s';", $this->getResyncUrl()),
            'class'      => 'action-secondary',
            'sort_order' => 100
        ];
    }

    /**
     * Get URL for resync product button
     *
     * @return string
     */
    protected function getResyncUrl(): string
    {
        return $this->getUrl('fastmagsync/catalog_product/resync', ['id' => $this->getProductId()]);
    }

    /**
     * Generate URL by route and parameters
     *
     * @param string $route
     * @param array  $params
     *
     * @return string
     */
    protected function getUrl($route = '', $params = []): string
    {
        return $this->context->getUrlBuilder()->getUrl($route, $params);
    }

    /**
     * Return product ID
     *
     * @return int|null
     */
    protected function getProductId(): ?int
    {
        return ($this->getProduct() !== null ? $this->getProduct()->getId() : null);
    }

    /**
     * Return current product
     *
     * @return Product|null
     */
    protected function getProduct(): ?Product
    {
        if ($this->currentProduct === null) {
            try {
                $this->currentProduct = $this->productRepository->getById($this->context->getRequest()->getParam('id'));
            } catch (NoSuchEntityException $exception) {
                // Do nothing
            }
        }

        return $this->currentProduct;
    }
}
