<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-25
 ******************************************************************************/

namespace Fastmag\Sync\Model;

use Fastmag\Sync\Api\Data\OrderInterface;
use Fastmag\Sync\Model\ResourceModel\Order as ResourceModel;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Order
 *
 * Synchronized orders model
 */
class Order extends AbstractModel implements OrderInterface
{
    /** @inheritDoc */
    protected $_cacheTag = 'fastmag_sync_order';

    /**
     * Order constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->getData(self::SYNC_ID);
    }

    /**
     * @inheritDoc
     */
    public function getOrderId()
    {
        return $this->getData(self::ORDER_ID);
    }

    /**
     * @inheritDoc
     */
    public function getTransactionId()
    {
        return $this->getData(self::TRANSACTION_ID);
    }

    /**
     * @inheritDoc
     */
    public function getTransactionIdBis()
    {
        return $this->getData(self::TRANSACTION_ID_BIS);
    }

    /**
     * @inheritDoc
     */
    public function getTransactionType()
    {
        return $this->getData(self::TRANSACTION_TYPE);
    }

    /**
     * @inheritDoc
     */
    public function getRequest()
    {
        return $this->getData(self::REQUEST);
    }

    /**
     * @inheritDoc
     */
    public function getEndpoint()
    {
        return $this->getData(self::ENDPOINT);
    }

    /**
     * @inheritDoc
     */
    public function getStatus()
    {
        return $this->getData(self::STATUS);
    }

    /**
     * @inheritDoc
     */
    public function getErrorCode()
    {
        return $this->getData(self::ERROR_CODE);
    }

    /**
     * @inheritDoc
     */
    public function getErrorMessage()
    {
        return $this->getData(self::ERROR_MESSAGE);
    }

    /**
     * @inheritDoc
     */
    public function getRequestAt()
    {
        return $this->getData(self::REQUEST_AT);
    }

    /**
     * @inheritDoc
     */
    public function getResultAt()
    {
        return $this->getData(self::RESULT_AT);
    }

    /**
     * @inheritDoc
     */
    public function getOriginShop()
    {
        return $this->getData(self::ORIGIN_SHOP);
    }

    /**
     * @inheritDoc
     */
    public function getTargetShop()
    {
        return $this->getData(self::TARGET_SHOP);
    }

    /**
     * @inheritDoc
     */
    public function setId($syncId)
    {
        return $this->setData(self::SYNC_ID, $syncId);
    }

    /**
     * @inheritDoc
     */
    public function setOrderId($orderId)
    {
        return $this->setData(self::ORDER_ID, $orderId);
    }

    /**
     * @inheritDoc
     */
    public function setTransactionId($transactionId)
    {
        return  $this->setData(self::TRANSACTION_ID, $transactionId);
    }

    /**
     * @inheritDoc
     */
    public function setTransactionIdBis($transactionIdBis)
    {
        return $this->setData(self::TRANSACTION_ID_BIS, $transactionIdBis);
    }

    /**
     * @inheritDoc
     */
    public function setTransactionType($type)
    {
        return $this->setData(self::TRANSACTION_TYPE, $type);
    }

    /**
     * @inheritDoc
     */
    public function setRequest($request)
    {
        return $this->setData(self::REQUEST, $request);
    }

    /**
     * @inheritDoc
     */
    public function setEndpoint($endpoint)
    {
        return $this->setData(self::ENDPOINT, $endpoint);
    }

    /**
     * @inheritDoc
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * @inheritDoc
     */
    public function setErrorCode($errorCode)
    {
        return $this->setData(self::ERROR_CODE, $errorCode);
    }

    /**
     * @inheritDoc
     */
    public function setErrorMessage($errorMessage)
    {
        return $this->setData(self::ERROR_MESSAGE, $errorMessage);
    }

    /**
     * @inheritDoc
     */
    public function setRequestAt($requestAt)
    {
        return $this->setData(self::REQUEST_AT, $requestAt);
    }

    /**
     * @inheritDoc
     */
    public function setResultAt($resultAt)
    {
        return $this->setData(self::RESULT_AT, $resultAt);
    }

    /**
     * @inheritDoc
     */
    public function setOriginShop($originShop)
    {
        return $this->setData(self::ORIGIN_SHOP, $originShop);
    }

    /**
     * @inheritDoc
     */
    public function setTargetShop($targetShop)
    {
        return $this->setData(self::TARGET_SHOP, $targetShop);
    }
}
