<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-25
 ******************************************************************************/

namespace Fastmag\Sync\Model\Rule;

use Fastmag\Sync\Api\Data\Rule\CarrierInterface;
use Fastmag\Sync\Model\ResourceModel\Rule\Carrier as ResourceModel;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Carrier
 *
 * Carrier rules model
 *
 * @SuppressWarnings(PHPMD.CamelCasePropertyName)
 */
class Carrier extends AbstractModel implements CarrierInterface
{
    /** @inheritDoc */
    protected $_cacheTag = 'fastmag_sync_rule_carrier';

    /** @inheritDoc */
    protected $_eventPrefix = 'fastmag_sync_rule_carrier';

    /**
     * Ordertransaction constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->getData(self::RULE_ID);
    }

    /**
     * @inheritDoc
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getUpdatedAt()
    {
        return $this->getData(self::UPDATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getMagentoCode()
    {
        return $this->getData(self::MAGENTO_CODE);
    }

    /**
     * @inheritDoc
     */
    public function getMethodCode()
    {
        return $this->getData(self::METHOD_CODE);
    }

    /**
     * @inheritDoc
     */
    public function getFastmagCode()
    {
        return $this->getData(self::FASTMAG_CODE);
    }

    /**
     * @inheritDoc
     */
    public function setId($ruleId)
    {
        return $this->setData(self::RULE_ID, $ruleId);
    }

    /**
     * @inheritDoc
     */
    public function setMagentoCode($magentoCode)
    {
        return $this->setData(self::MAGENTO_CODE, $magentoCode);
    }

    /**
     * @inheritDoc
     */
    public function setMethodCode($methodCode)
    {
        return $this->setData(self::METHOD_CODE, $methodCode);
    }

    /**
     * @inheritDoc
     */
    public function setFastmagCode($fastmagCode)
    {
        return $this->setData(self::FASTMAG_CODE, $fastmagCode);
    }
}
