<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-19
 ******************************************************************************/

namespace Fastmag\Sync\Process\Entity\Helper\Attribute;

use Fastmag\Sync\Process\Entity\Helper\AttributeInterface;

/**
 * Class Gender
 *
 * Helper class to help format gender for Magento
 */
class Gender implements AttributeInterface
{
    /** @var int $defaultMagentoValue */
    protected static $defaultMagentoValue = 3;

    /** @var string $defaultFastmagValue */
    protected static $defaultFastmagValue;

    /** @var array $magentoValues */
    protected static $magentoValues = [
        'F' => 2,
        'M' => 1,
    ];

    /** @var array $fastmagValues */
    protected static $fastmagValues = [
        1 => 'M',
        2 => 'F'
    ];

    /**
     * @inheritDoc
     *
     * @param string $fastmagValue
     *
     * @return int
     */
    public static function getMagentoValue($fastmagValue)
    {
        $result = self::getDefaultMagentoValue();

        if (array_key_exists($fastmagValue, self::$magentoValues)) {
            $result = self::$magentoValues[$fastmagValue];
        }

        return $result;
    }

    /**
     * @inheritDoc
     *
     * @param string $magentoValue
     *
     * @return int
     */
    public static function getFastmagValue($magentoValue)
    {
        $result = self::getDefaultFastmagValue();

        if (array_key_exists($magentoValue, self::$fastmagValues)) {
            $result = self::$fastmagValues[$magentoValue];
        }

        return $result;
    }

    /**
     * @inheritDoc
     *
     * @return int
     */
    public static function getDefaultMagentoValue()
    {
        return self::$defaultMagentoValue;
    }

    /**
     * @inheritDoc
     *
     * @return string
     */
    public static function getDefaultFastmagValue()
    {
        return self::$defaultFastmagValue;
    }
}
