<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-11-11
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker;

use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Jobqueue;
use Fastmag\Sync\Process\EntityInterface;
use Magento\Framework\Serialize\Serializer\Json;

/**
 * Trait Hydration
 *
 * Trait for all hydration workers (to Fastmag and to Magento)
 */
trait Hydration
{
    use Standard;

    /** @var Config $config */
    protected $config;

    /** @var Json $jsonSerializer */
    protected $jsonSerializer;

    /**
     * Hydrate job with entity
     *
     * @param Jobqueue        $job
     * @param EntityInterface $entity
     *
     * @return Standard
     */
    public function hydrateJob($job, $entity)
    {
        $this->jobRepository->hydrate($job, $entity);

        $this->debug($job, 'Data hydrated: ' . $this->jsonSerializer->serialize($job->getHydratedData()));

        return $this;
    }
}
