<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-19
 ******************************************************************************/

namespace Fastmag\Sync\Api\Rule;

/**
 * Interface TaxclassfamilyRepositoryInterface
 */
interface TaxclassfamilyRepositoryInterface
{
    /**
     * Save rule.
     *
     * @param \Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface $rule
     *
     * @return \Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(\Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface $rule)
    : \Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface;

    /**
     * Retrieve rule.
     *
     * @param int $ruleId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($ruleId);

    /**
     * Retrieve rules matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\Rule\TaxclassfamilySearchResultsInterface
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria);

    /**
     * Delete rule.
     *
     * @param \Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface $rule
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(\Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface $rule): bool;

    /**
     * Delete rule by ID.
     *
     * @param int $ruleId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($ruleId);
}
