<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-03-18
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Customer;

use Fastmag\Sync\Model\Constants;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class Action
 *
 * Source for action to make on customer data deletion in Magento
 */
class Action implements OptionSourceInterface
{
    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        return [
            [
                'value' => Constants::CUSTOMER_GDPR_ACTION_NOTHING,
                'label' => __('Do nothing in Fastmag')
            ],
            [
                'value' => Constants::CUSTOMER_GDPR_ACTION_NOTICE,
                'label' => __('Send notice to Fastmag for manually delete customers data')
            ],
            [
                'value' => Constants::CUSTOMER_GDPR_ACTION_ANONYMIZE,
                'label' => __('Anonymize customer data in Fastmag')
            ],
            [
                'value' => Constants::CUSTOMER_GDPR_ACTION_DELETE,
                'label' => __('Delete customer data in Fastmag')
            ],
        ];
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            Constants::CUSTOMER_GDPR_ACTION_NOTHING => __('Do nothing in Fastmag'),
            Constants::CUSTOMER_GDPR_ACTION_NOTICE => __('Send notice to Fastmag for manually delete customers data'),
            Constants::CUSTOMER_GDPR_ACTION_ANONYMIZE => __('Anonymize customer data in Fastmag'),
            Constants::CUSTOMER_GDPR_ACTION_DELETE => __('Delete customer data in Fastmag'),
        ];
    }
}
