<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-10-14
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Jobqueue;

use Fastmag\Sync\Model\Jobqueue;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class Status
 *
 * Source for job status config field
 */
class Status implements OptionSourceInterface
{
    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        return [
            ['value' => Jobqueue::STATUS_PENDING, 'label' => __('Pending')],
            ['value' => Jobqueue::STATUS_RUNNING, 'label' => __('Running')],
            ['value' => Jobqueue::STATUS_SUCCESS, 'label' => __('Success')],
            ['value' => Jobqueue::STATUS_SKIPPED, 'label' => __('Skipped')],
            ['value' => Jobqueue::STATUS_ERROR, 'label' => __('Error')],
        ];
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            Jobqueue::STATUS_PENDING => __('Pending'),
            Jobqueue::STATUS_RUNNING => __('Running'),
            Jobqueue::STATUS_SUCCESS => __('Success'),
            Jobqueue::STATUS_SKIPPED => __('Skipped'),
            Jobqueue::STATUS_ERROR   => __('Error'),
        ];
    }
}
