<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-19
 ******************************************************************************/

namespace Fastmag\Sync\Model\System\Preconfig;

use Exception;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem\Driver\File;
use Magento\Framework\Notification\MessageInterface;
use Magento\Framework\UrlInterface;

/**
 * Class Message
 *
 * Class handling the reminder to delete the temp folder of Fastmag pre-config
 */
class Message implements MessageInterface
{
    /** @var UrlInterface $urlBuilder */
    protected $urlBuilder;

    /** @var DirectoryList $directoryList */
    protected $directoryList;

    /** @var File $fileDriver */
    protected $fileDriver;

    /**
     * Preconfig constructor
     *
     * @param UrlInterface  $urlBuilder
     * @param DirectoryList $directoryList
     * @param File          $fileDriver
     */
    public function __construct(
        UrlInterface $urlBuilder,
        DirectoryList $directoryList,
        File $fileDriver
    ) {
        $this->urlBuilder = $urlBuilder;
        $this->directoryList = $directoryList;
        $this->fileDriver = $fileDriver;
    }

    /**
     * @inheritDoc
     */
    public function getText()
    {
        return __(
            'The FastmagSync pre-config folder is still present and accessible by everyone.'
            . ' If the installation is done, please delete this folder by '
        ) . '<a href="' . $this->urlBuilder->getUrl('fastmagsync/preconfig/delete') . '">'
            . __('clicking here') . '</a>';
    }

    /**
     * @inheritDoc
     */
    public function getIdentity()
    {
        return md5('PRECONFIG_FILES_TO_REMOVE');
    }

    /**
     * @inheritDoc
     */
    public function isDisplayed()
    {
        $result = false;

        try {
            $path = $this->directoryList->getPath(DirectoryList::VAR_DIR) . DIRECTORY_SEPARATOR . 'fmtmp';

            if ($this->fileDriver->isExists($path)) {
                $result = true;
            }
        } catch (Exception $exception) {
            // Do nothing
        }

        return $result;
    }

    /**
     * @inheritDoc
     */
    public function getSeverity()
    {
        return MessageInterface::SEVERITY_CRITICAL;
    }
}
