<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-02-15
 ******************************************************************************/

namespace Fastmag\Sync\Plugin\Jobqueue\ToFastmag;

use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Plugin\Jobqueue\ToFastmag;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\OrderRepositoryInterface as OrderRepository;
use Magento\Sales\Model\Order as OrderModel;

/**
 * Class Order
 *
 * Plugin on OrderRepository to add a matching job in ToFastmag job queue
 */
class Order extends ToFastmag
{
    /**
     * @see OrderRepository::save()
     *
     * @param OrderRepository $subject
     * @param OrderInterface  $order
     *
     * @return OrderInterface
     */
    public function afterSave(OrderRepository $subject, $order)
    {
        if ($order->getEntityId()
            && $order->getPayment()
            && !$this->isCalledByFastmagModule()
            && $this->config->isSetFlag(Config::XML_PATH_ORDER_EXPORT_ENABLE)
            && !in_array($order->getState(), ['', OrderModel::STATE_CLOSED, OrderModel::STATE_CANCELED], true)
        ) {
            try {
                $key = $order->getEntityId() . '_' . $order->getStatus();

                $job = $this->jobFactory->create();
                $job->setContentId($key)
                    ->setJobCode('tofastmag_integration_order');

                $this->jobRepository->save($job);
            } catch (CouldNotSaveException $exception) {
                $this->logger->error($exception->getMessage());
            }
        }

        return $order;
    }
}
