<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-05
 ******************************************************************************/

namespace Fastmag\Sync\Plugin\Sales;

use Closure;
use Magento\Quote\Model\Quote\Item\AbstractItem;
use Magento\Quote\Model\Quote\Item\ToOrderItem;
use Magento\Sales\Model\Order\Item;

/**
 * Class ConvertProductAttributesQuoteToOrderItem
 *
 * Plugin on ToOrderItem to convert quote item Fastmag attributes to the order item's ones
 */
class ConvertProductAttributesQuoteToOrderItem
{
    /**
     * Add Fastmag product attributes to order item when converting quote item to order item
     *
     * @see ToOrderItem::convert
     *
     * @param ToOrderItem  $subject
     * @param Closure      $proceed
     * @param AbstractItem $item
     * @param array        $additional
     *
     * @return Item
     */
    public function aroundConvert(
        ToOrderItem $subject,
        Closure $proceed,
        AbstractItem $item,
        $additional = []
    ) {
        /** @var $orderItem Item */
        $orderItem = $proceed($item, $additional);
        $orderItem->setFastmagProductId($item->getFastmagProductId());

        return $orderItem;
    }
}
