<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Ui\Component\Listing\Column\Jobqueue\ToFastmag;

use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class OrderAdditionnalData
 *
 * Column renderer for orders additionnal data for order related jobs
 *
 * @todo > 1.0.0 : delete class
 */
class OrderAdditionnalData extends Column
{
    /** @var UrlInterface $urlBuilder */
    protected $urlBuilder;

    /** @var OrderRepositoryInterface $orderRepository */
    protected $orderRepository;

    /**
     * OrderAdditionnalData constructor
     *
     * @param ContextInterface         $context
     * @param UiComponentFactory       $uiComponentFactory
     * @param UrlInterface             $urlBuilder
     * @param OrderRepositoryInterface $orderRepository
     * @param array                    $components
     * @param array                    $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        UrlInterface $urlBuilder,
        OrderRepositoryInterface $orderRepository,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);

        $this->urlBuilder = $urlBuilder;
        $this->orderRepository = $orderRepository;
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $item[$this->getData('name')] = $this->prepareItem($item);
            }
        }

        return $dataSource;
    }

    /**
     * Get data
     *
     * @param array $item
     *
     * @return string
     */
    protected function prepareItem(array $item)
    {
        $contentId = $item['content_id'];
        $jobCode = $item['job_code'];
        $html = $contentId;

        if (strpos($jobCode, 'order') !== false) {
            /* @todo > 1.0.0 : add history */
            $html = '<a target="_blank" href="'
                . $this->urlBuilder->getUrl('sales/order/view', ['order_id' => $contentId]) . '">'
                . $item['increment_id'] . '</a>';
        }

        return $html;
    }
}
