<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-01-05
 ******************************************************************************/

namespace Fastmag\Sync\Ui\Component\Listing\Column\Order;

use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class Error
 *
 * Column renderer for synced orders increment IDs
 */
class Error extends Column
{
    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     *
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $item[$this->getData('name')] = $this->prepareItem($item);
            }
        }

        return $dataSource;
    }

    /**
     * Get data
     *
     * @param array $item
     *
     * @return string
     */
    protected function prepareItem(array $item)
    {
        $errorCode = $item['error_code'];
        $errorMessage = $item['error_message'];
        $html = '';

        if ($errorCode) {
            $html = __('Error code: ') . $errorCode . '<br />' . __('Error message: ') . $errorMessage;
        }

        return $html;
    }
}
