<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-10-31
 ******************************************************************************/

namespace Fastmag\Sync\Block\Adminhtml\System\Config\Connection;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

/**
 * Class Api
 *
 * Config field block displaying API connection status
 *
 * @see \Magento\Customer\Block\Adminhtml\System\Config\Validatevat
 *
 * @method string getButtonLabel()
 * @method string getHtmlId()
 * @method string getAjaxUrl()
 */
class Api extends Field
{
    /** @var string $hostField */
    protected $hostField = 'fastmag_sync_connect_api_host';

    /** @var string $chainField */
    protected $chainField = 'fastmag_sync_connect_api_chain';

    /** @var string $shopField */
    protected $shopField = 'fastmag_sync_connect_api_shop';

    /** @var string $userField */
    protected $userField = 'fastmag_sync_connect_api_user';

    /** @var string $passwordField */
    protected $passwordField = 'fastmag_sync_connect_api_password';

    /** @var string $buttonLabel */
    protected $buttonLabel = 'Test connection';

    /** @var string $resultField */
    protected $resultField = 'test_connection_api_result';

    /** @var string $resultFieldPrefixId */
    protected $resultFieldPrefixId = 'result_fastmag_sync_connect_api_connection_';

    /**
     * Get host field name
     *
     * @return string
     */
    public function getHostField()
    {
        return $this->hostField;
    }

    /**
     * Get chain field name
     *
     * @return string
     */
    public function getChainField()
    {
        return $this->chainField;
    }

    /**
     * Get shop field name
     *
     * @return string
     */
    public function getShopField()
    {
        return $this->shopField;
    }

    /**
     * Get user field name
     *
     * @return string
     */
    public function getUserField()
    {
        return $this->userField;
    }

    /**
     * Get password field name
     *
     * @return string
     */
    public function getPasswordField()
    {
        return $this->passwordField;
    }

    /**
     * Get ID for field displaying the result of Fastmag API connection
     *
     * @return string
     */
    public function getResultField()
    {
        return $this->resultField;
    }

    /**
     * Get ID for field displaying the result of Fastmag API connection
     *
     * @param string $suffix
     *
     * @return string
     */
    public function getResultFieldId($suffix)
    {
        return $this->resultFieldPrefixId . $suffix;
    }

    /**
     * @inheritDoc
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();

        $this->setTemplate('system/config/connection/api.phtml');

        return $this;
    }

    /**
     * Unset some non-related element parameters
     *
     * @param AbstractElement $element
     *
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();

        return parent::render($element);
    }

    /**
     * Get the button and scripts contents
     *
     * @param AbstractElement $element
     *
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        $originalData = $element->getOriginalData();
        $buttonLabel = !empty($originalData['button_label']) ? $originalData['button_label'] : $this->buttonLabel;
        $this->addData(
            [
                'button_label' => __($buttonLabel),
                'html_id'      => $element->getHtmlId(),
                'ajax_url'     => $this->_urlBuilder->getUrl('fastmagsync/system_config_connection/api'),
            ]
        );

        return $this->_toHtml();
    }
}
