<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-25
 ******************************************************************************/

namespace Fastmag\Sync\Model\Rule;

use Fastmag\Sync\Api\Data\Rule\OrdertransactionInterface;
use Fastmag\Sync\Model\ResourceModel\Rule\Ordertransaction as ResourceModel;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Ordertransaction
 *
 * Ordertransaction rules model
 *
 * @SuppressWarnings(PHPMD.CamelCasePropertyName)
 */
class Ordertransaction extends AbstractModel implements OrdertransactionInterface
{
    /** @inheritDoc */
    protected $_cacheTag = 'fastmag_sync_rule_ordertransaction';

    /** @inheritDoc */
    protected $_eventPrefix = 'fastmag_sync_rule_ordertransaction';

    /**
     * Ordertransaction constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->getData(self::RULE_ID);
    }

    /**
     * @inheritDoc
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getUpdatedAt()
    {
        return $this->getData(self::UPDATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getPaymentMethod()
    {
        return $this->getData(self::PAYMENT_METHOD);
    }

    /**
     * @inheritDoc
     */
    public function getOrderStatus()
    {
        return $this->getData(self::ORDER_STATUS);
    }

    /**
     * @inheritDoc
     */
    public function getTransactionType()
    {
        return $this->getData(self::TRANSACTION_TYPE);
    }

    /**
     * @inheritDoc
     */
    public function setId($ruleId)
    {
        return $this->setData(self::RULE_ID, $ruleId);
    }

    /**
     * @inheritDoc
     */
    public function setPaymentMethod($paymentMethod)
    {
        return $this->setData(self::PAYMENT_METHOD, $paymentMethod);
    }

    /**
     * @inheritDoc
     */
    public function setOrderStatus($orderStatus)
    {
        return $this->setData(self::ORDER_STATUS, $orderStatus);
    }

    /**
     * @inheritDoc
     */
    public function setTransactionType($transactionType)
    {
        return $this->setData(self::TRANSACTION_TYPE, $transactionType);
    }
}
