<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-03-01
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToFastmag\Hydration\Customer;

use Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface as Job;
use Fastmag\Sync\Api\Jobqueue\ToFastmagRepositoryInterface as JobRepository;
use Fastmag\Sync\Exception\JobException;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Process\Entity\ToFastmag\CustomerFactory as CustomerEntityFactory;
use Fastmag\Sync\Process\Worker;
use Fastmag\Sync\Process\Worker\ToFastmag\Hydration as HydrationTrait;
use Magento\Framework\Serialize\Serializer\Json;

class Deletion extends Worker
{
    use HydrationTrait;

    /** @inheritDoc */
    protected $code = 'tofastmag_hydration_customer_deletion';

    /** @var Json $jsonSerializer */
    protected $jsonSerializer;

    /** @var CustomerEntityFactory $customerEntityFactory */
    protected $customerEntityFactory;

    /** @var Job $currentJob */
    protected $currentJob;

    /**
     * Deletion constructor
     *
     * @param Logger                   $logger
     * @param JobRepository            $jobRepository
     * @param Config                   $config
     * @param Json                     $jsonSerializer
     * @param CustomerEntityFactory    $customerEntityFactory
     */
    public function __construct(
        Logger $logger,
        JobRepository $jobRepository,
        Config $config,
        Json $jsonSerializer,
        CustomerEntityFactory $customerEntityFactory
    ) {
        parent::__construct($logger);

        $this->jobRepository = $jobRepository;
        $this->config = $config;
        $this->jsonSerializer = $jsonSerializer;
        $this->customerEntityFactory = $customerEntityFactory;
    }

    /**
     * @inheritDoc
     */
    public function run()
    {
        foreach ($this->getJobs()->getItems() as $job) {
            $this->currentJob = $job;
            $customerEntity = $this->getDataFromMagento();

            if ($customerEntity->getFastmagId() === null) {
                $exception = new JobException(__('The customer does not have a Fastmag ID'));
                $this->invalidateJob($job, $exception);
            } else {
                $job->setEntity($customerEntity);
            }

            $this->saveJob($job);
        }
    }

    /**
     * @inheritDoc
     */
    protected function getDataFromMagento()
    {
        // TODO: change (un)serializer logic for jobs to always get unserialized data and save serialized data
        $jobHydratedData = $this->jsonSerializer->unserialize($this->currentJob->getHydratedData());

        return $this->customerEntityFactory->create(['data' => $jobHydratedData]);
    }
}
