<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-19
 ******************************************************************************/

namespace Fastmag\Sync\Api;

/**
 * Interface LogApiRepositoryInterface
 */
interface LogApiRepositoryInterface
{
    /**
     * Save log.
     *
     * @param \Fastmag\Sync\Api\Data\LogApiInterface $log
     *
     * @return \Fastmag\Sync\Api\Data\LogApiInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(\Fastmag\Sync\Api\Data\LogApiInterface $log): \Fastmag\Sync\Api\Data\LogApiInterface;

    /**
     * Retrieve log.
     *
     * @param int $logId
     *
     * @return \Fastmag\Sync\Api\Data\LogApiInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($logId);

    /**
     * Retrieve logs matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\LogApiSearchResultsInterface
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria);

    /**
     * Delete log.
     *
     * @param \Fastmag\Sync\Api\Data\LogApiInterface $log
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(\Fastmag\Sync\Api\Data\LogApiInterface $log): bool;

    /**
     * Delete log by ID.
     *
     * @param int $logId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($logId);
}
