<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-11-19
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

/**
 * Class Provider
 */
abstract class Provider
{
    /** @var ScopeConfigInterface */
    protected $scopeConfig;

    /**
     * ConfigProvider constructor.
     *
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig
    ) {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * An alias for scope config with default scope type SCOPE_STORES
     *
     * @param string $key
     * @param string $scopeType
     *
     * @return string|null
     */
    public function getValue($key, $scopeType = ScopeInterface::SCOPE_STORES)
    {
        return $this->scopeConfig->getValue($key, $scopeType);
    }
}
