<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-01-26
 ******************************************************************************/

namespace Fastmag\Sync\Model\Extractor\Order\Items;

use Magento\Framework\Module\Manager as ModuleManager;
use Magento\Framework\ObjectManagerInterface as ObjectManager;

/**
 * Class ExtractorFactory
 *
 * Factory class for order items extractor classes
 */
class ExtractorFactory
{
    protected ObjectManager $objectManager;
    protected ModuleManager $moduleManager;

    protected array $extractors = [];

    /**
     * ExtractorFactory constructor
     *
     * @param ObjectManager $objectManager
     * @param ModuleManager $moduleManager
     * @param string[]      $extractors
     */
    public function __construct(ObjectManager $objectManager, ModuleManager $moduleManager, array $extractors = [])
    {
        $this->objectManager = $objectManager;
        $this->moduleManager = $moduleManager;
        $this->extractors = $extractors;
    }

    /**
     * Create class instance with specified parameters
     *
     * @param array  $data
     *
     * @return Extractor
     */
    public function create(array $data = []): Extractor
    {
        if ($this->moduleManager->isEnabled('Ewave_ExtendedBundleProduct')) {
            $instanceName = $this->extractors['extended_bundle'];
        } else {
            $instanceName = $this->extractors['standard'];
        }

        return $this->objectManager->create($instanceName, $data);
    }
}
