<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-05-10
 ******************************************************************************/

namespace Fastmag\Sync\Setup\Patch\Data;

use Fastmag\Sync\Model\Constants;
use Magento\Catalog\Model\Product;
use Magento\Catalog\Model\Product\Type;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Setup\ModuleDataSetupInterface as ModuleDataSetup;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchRevertableInterface;
use Magento\Framework\Validator\ValidateException;
use Magento\Quote\Setup\QuoteSetupFactory;
use Magento\Sales\Setup\SalesSetupFactory;

/**
 * Class InstallFastmagGencodAttribute
 *
 * Installer for product fastmag_gencod attribute in catalog and sales item
 */
class InstallFastmagGencodAttribute implements DataPatchInterface, PatchRevertableInterface
{
    /** @var ModuleDataSetup $moduleDataSetup */
    protected ModuleDataSetup $moduleDataSetup;

    /** @var EavSetupFactory $eavSetupFactory */
    protected EavSetupFactory $eavSetupFactory;

    /** @var QuoteSetupFactory $quoteSetupFactory */
    protected QuoteSetupFactory $quoteSetupFactory;

    /** @var SalesSetupFactory $salesSetupFactory */
    protected SalesSetupFactory $salesSetupFactory;

    /**
     * InstallFastmagGencodAttribute constructor
     *
     * @param ModuleDataSetup   $moduleDataSetup
     * @param EavSetupFactory   $eavSetupFactory
     * @param QuoteSetupFactory $quoteSetupFactory
     * @param SalesSetupFactory $salesSetupFactory
     */
    public function __construct(
        ModuleDataSetup   $moduleDataSetup,
        EavSetupFactory   $eavSetupFactory,
        QuoteSetupFactory $quoteSetupFactory,
        SalesSetupFactory $salesSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
        $this->quoteSetupFactory = $quoteSetupFactory;
        $this->salesSetupFactory = $salesSetupFactory;
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies(): array
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getAliases(): array
    {
        return [];
    }

    /**
     * @inheritDoc
     *
     * @throws LocalizedException
     * @throws ValidateException
     */
    public function apply()
    {
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $eavSetup->addAttribute(
            Product::ENTITY,
            Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE,
            [
                'label'    => 'Fastmag product ID',
                'type'     => 'int',
                'required' => false,
                'unique'   => true,
                'apply_to' => Type::TYPE_SIMPLE
            ]
        );

        $quoteSetup = $this->quoteSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $quoteSetup->addAttribute(
            'quote_item',
            Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE,
            ['type' => 'int']
        );

        $salesSetup = $this->salesSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $salesSetup->addAttribute(
            'order_item',
            Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE,
            ['type' => 'int']
        );
    }

    /**
     * @inheritDoc
     */
    public function revert()
    {
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $eavSetup->removeAttribute(Product::ENTITY, Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE);

        $quoteSetup = $this->quoteSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $quoteSetup->removeAttribute('quote_item', Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE);

        $salesSetup = $this->salesSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $salesSetup->removeAttribute('quote_item', Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE);
    }
}
