<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-12-02
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data;

/**
 * Interface OrderInterface
 */
interface OrderInterface
{
    /** @var string */
    public const SYNC_ID = 'sync_id';

    /** @var string */
    public const ORDER_ID = 'order_id';

    /** @var string */
    public const TRANSACTION_ID = 'transaction_id';

    /** @var string */
    public const TRANSACTION_ID_BIS = 'transaction_id_bis';

    /** @var string */
    public const TRANSACTION_TYPE = 'transaction_type';

    /** @var string */
    public const REQUEST = 'request';

    /** @var string */
    public const ENDPOINT = 'endpoint';

    /** @var string */
    public const STATUS = 'status';

    /** @var string */
    public const ERROR_CODE = 'error_code';

    /** @var string */
    public const ERROR_MESSAGE = 'error_message';

    /** @var string */
    public const REQUEST_AT = 'request_at';

    /** @var string */
    public const RESULT_AT = 'result_at';

    /** @var string */
    public const ORIGIN_SHOP = 'origin_shop';

    /** @var string */
    public const TARGET_SHOP = 'target_shop';

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get order ID
     *
     * @return int|null
     */
    public function getOrderId();

    /**
     * Get transaction ID
     *
     * @return int|null
     */
    public function getTransactionId();

    /**
     * Get transaction ID bis
     *
     * @return int|null
     */
    public function getTransactionIdBis();

    /**
     * Get transaction type
     *
     * @return string|null
     */
    public function getTransactionType();

    /**
     * Get request
     *
     * @return string|null
     */
    public function getRequest();

    /**
     * Get endpoint
     *
     * @return string|null
     */
    public function getEndpoint();

    /**
     * Get status
     *
     * @return string|null
     */
    public function getStatus();

    /**
     * Get error code
     *
     * @return string|null
     */
    public function getErrorCode();

    /**
     * Get error message
     *
     * @return string|null
     */
    public function getErrorMessage();

    /**
     * Get request at
     *
     * @return string|null
     */
    public function getRequestAt();

    /**
     * Get result at
     *
     * @return string|null
     */
    public function getResultAt();

    /**
     * Get origin shop
     *
     * @return string|null
     */
    public function getOriginShop();

    /**
     * Get target shop
     *
     * @return string|null
     */
    public function getTargetShop();

    /**
     * Set ID
     *
     * @param int $syncId
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setId($syncId);

    /**
     * Set order ID
     *
     * @param int $orderId
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setOrderId($orderId);

    /**
     * Set transaction ID
     *
     * @param int $transactionId
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setTransactionId($transactionId);

    /**
     * Set transaction ID bis
     *
     * @param int $transactionIdBis
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setTransactionIdBis($transactionIdBis);

    /**
     * Set transaction type
     *
     * @param string $type
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setTransactionType($type);

    /**
     * Set request
     *
     * @param string $request
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setRequest($request);

    /**
     * Set endpoint
     *
     * @param string $endpoint
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setEndpoint($endpoint);

    /**
     * Set status
     *
     * @param string $status
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setStatus($status);

    /**
     * Set error code
     *
     * @param string $errorCode
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setErrorCode($errorCode);

    /**
     * Set error message
     *
     * @param string $errorMessage
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setErrorMessage($errorMessage);

    /**
     * Set request at
     *
     * @param string $requestAt
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setRequestAt($requestAt);

    /**
     * Set result at
     *
     * @param string $resultAt
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setResultAt($resultAt);

    /**
     * Set origin shop
     *
     * @param string $originShop
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setOriginShop($originShop);

    /**
     * Set target shop
     *
     * @param string $targetShop
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setTargetShop($targetShop);
}
