<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-05-16
 ******************************************************************************/

namespace Fastmag\Sync\FastmagSetup;

/**
 * Class Installer
 *
 * Class handling job queue installation on Fastmag
 */
class Installer
{
    /** @var string[] */
    protected $sql = [];

    /**
     * Get installation queries
     *
     * @return array
     */
    public function getInstallQueries()
    {
        $this->sql['fmsync_job_queue'] = '
            CREATE TABLE IF NOT EXISTS fmsync_job_queue (
                id_job INT(10) NOT NULL AUTO_INCREMENT,
                identifiant VARCHAR(60) DEFAULT NULL,
                job VARCHAR(20) DEFAULT NULL,
                code_mag VARCHAR(30) DEFAULT NULL,
                date_creation DATETIME NOT NULL,
                date_maj DATETIME DEFAULT NULL,
                date_a_traiter DATETIME DEFAULT NULL,
                commentaire LONGTEXT DEFAULT NULL,
                priorite BIGINT(8) UNSIGNED NOT NULL DEFAULT 0,
                checksum VARCHAR(100) DEFAULT \'\',
                PRIMARY KEY(id_job),
                INDEX(job),
                INDEX(identifiant),
                INDEX(code_mag),
                INDEX(date_a_traiter),
                UNIQUE KEY index_job_queue_unique (job, identifiant, checksum)
            ) ENGINE=MYISAM DEFAULT CHARSET=utf8;';

        return $this->sql;
    }
}
