<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2025 HOMEMADE.IO SAS
 * @date      2025-09-03
 ******************************************************************************/

namespace Fastmag\Sync\Model;

use Fastmag\Sync\Logger\Logger;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;

/**
 * Class Jobqueue
 *
 * Abstract class for jobs models (To Fastmag and To Magento)
 *
 * phpcs:disable Magento2.Commenting.ClassPropertyPHPDocFormatting.Missing
 */
abstract class Jobqueue extends AbstractModel
{
    /** @var string */
    public const STATUS_PENDING = 'pending';

    /** @var string */
    public const STATUS_RUNNING = 'running';

    /** @var string */
    public const STATUS_SUCCESS = 'success';

    /** @var string */
    public const STATUS_ERROR = 'error';

    /** @var string */
    public const STATUS_SKIPPED = 'skipped';

    protected Logger $logger;

    /**
     * Jobqueue constructor.
     *
     * @param Context               $context
     * @param Registry              $registry
     * @param Logger                $logger
     * @param AbstractResource|null $resource
     * @param AbstractDb|null       $resourceCollection
     * @param array                 $data
     */
    public function __construct(
        Context           $context,
        Registry          $registry,
        Logger            $logger,
        ?AbstractResource $resource = null,
        ?AbstractDb       $resourceCollection = null,
        array             $data = []
    ) {
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);

        $this->logger = $logger;
    }

    /**
     * Get status
     *
     * @return string|null
     */
    abstract public function getStatus();

    /**
     * Get error message
     *
     * @return string|null
     */
    abstract public function getMessage();

    /**
     * Set status
     *
     * @param string $status
     *
     * @return Jobqueue
     */
    abstract public function setStatus($status);

    /**
     * Check if the job did get a previous error during the process
     *
     * @return bool
     */
    public function isInError()
    {
        return $this->getMessage() !== null;
    }
}
