<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-25
 ******************************************************************************/

namespace Fastmag\Sync\Model;

use Fastmag\Sync\Api\Data\LogInterface;
use Fastmag\Sync\Model\ResourceModel\Log as ResourceModel;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Log
 *
 * Log model
 *
 * @SuppressWarnings(PHPMD.CamelCasePropertyName)
 */
class Log extends AbstractModel implements LogInterface
{
    /** @inheritDoc */
    protected $_cacheTag = 'fastmag_sync_log';

    /**
     * Log constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->getData(self::LOG_ID);
    }

    /**
     * @inheritDoc
     */
    public function getMessage()
    {
        return $this->getData(self::MESSAGE);
    }

    /**
     * inheritDoc
     */
    public function getLevel()
    {
        return $this->getData(self::LEVEL);
    }

    /**
     * @inheritDoc
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function setId($logId)
    {
        return $this->setData(self::LOG_ID, $logId);
    }

    /**
     * @inheritDoc
     */
    public function setMessage($message)
    {
        return $this->setData(self::MESSAGE, $message);
    }

    /**
     * @inheritDoc
     */
    public function setLevel($level)
    {
        return $this->setData(self::LEVEL, $level);
    }
}
