<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-19
 ******************************************************************************/

namespace Fastmag\Sync\Process\Entity\Helper\Attribute;

use Fastmag\Sync\Process\Entity\Helper\AttributeInterface;

/**
 * Class Prefix
 *
 * Helper class to help format prefix for Magento
 */
class Prefix implements AttributeInterface
{
    /** @var string $defaultMagentoValue */
    protected static $defaultMagentoValue = 'M';

    /** @var string $defaultFastmagValue */
    protected static $defaultFastmagValue = 'MONSIEUR';

    /** @var array $values */
    protected static $magentoValues = [
        'MADAME'       => 'Mme',
        'MME'          => 'Mme',
        'MADEMOISELLE' => 'Mme',
        'MELLE'        => 'Mme',
        'MONSIEUR'     => 'M',
        'M'            => 'M',
        'MR'           => 'M',
        'SOCIETE'      => 'Ste'
    ];

    /** @var array $fastmagValues */
    protected static $fastmagValues = [
        'MME'   => 'MADAME',
        'MELLE' => 'MADAME',
        'M'     => 'MONSIEUR',
        'MR'    => 'MONSIEUR',
        'STE'   => 'SOCIETE'
    ];

    /**
     * @inheritDoc
     *
     * @param string $fastmagValue
     *
     * @return int|null
     */
    public static function getMagentoValue($fastmagValue)
    {
        $result = self::getDefaultMagentoValue();

        if (array_key_exists($fastmagValue, self::$magentoValues)) {
            $result = self::$magentoValues[$fastmagValue];
        }

        return $result;
    }

    /**
     * @inheritDoc
     *
     * @param string $magentoValue
     *
     * @return int
     */
    public static function getFastmagValue($magentoValue)
    {
        $result = self::getDefaultFastmagValue();

        if (array_key_exists(strtoupper($magentoValue), self::$fastmagValues)) {
            $result = self::$fastmagValues[strtoupper($magentoValue)];
        }

        return $result;
    }

    /**
     * @inheritDoc
     *
     * @return string
     */
    public static function getDefaultMagentoValue(): string
    {
        return self::$defaultMagentoValue;
    }

    /**
     * @inheritDoc
     *
     * @return string
     */
    public static function getDefaultFastmagValue(): string
    {
        return self::$defaultFastmagValue;
    }
}
