<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-06
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data\Rule;

/**
 * Interface TaxclassfamilyInterface
 */
interface TaxclassfamilyInterface
{
    /** @var string */
    public const RULE_ID = 'rule_id';

    /** @var string */
    public const CREATED_AT = 'created_at';

    /** @var string */
    public const UPDATED_AT = 'updated_at';

    /** @var string */
    public const FAMILY = 'family';

    /** @var string */
    public const TAX_CLASS_ID = 'tax_class_id';

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get created at
     *
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Get updated at
     *
     * @return string|null
     */
    public function getUpdatedAt();

    /**
     * Get family
     *
     * @return string|null
     */
    public function getFamily();

    /**
     * Get tax class ID
     *
     * @return int|null
     */
    public function getTaxClassId();

    /**
     * Set ID
     *
     * @param int $ruleId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface
     */
    public function setId($ruleId);

    /**
     * Set family
     *
     * @param string $family
     *
     * @return \Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface
     */
    public function setFamily($family);

    /**
     * Set tax class ID
     *
     * @param int $taxClassId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface
     */
    public function setTaxClassId($taxClassId);
}
