<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2025 HOMEMADE.IO SAS
 * @date      2025-09-03
 ******************************************************************************/

namespace Fastmag\Sync\Api;

/**
 * Interface LogRepositoryInterface
 */
interface LogRepositoryInterface
{
    /**
     * Save log.
     *
     * @param \Fastmag\Sync\Api\Data\LogInterface $log
     *
     * @return \Fastmag\Sync\Api\Data\LogInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(\Fastmag\Sync\Api\Data\LogInterface $log): \Fastmag\Sync\Api\Data\LogInterface;

    /**
     * Retrieve log.
     *
     * @param int $logId
     *
     * @return \Fastmag\Sync\Api\Data\LogInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($logId): \Fastmag\Sync\Api\Data\LogInterface;

    /**
     * Retrieve logs matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\LogSearchResultsInterface
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria);

    /**
     * Delete log.
     *
     * @param \Fastmag\Sync\Api\Data\LogInterface $log
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(\Fastmag\Sync\Api\Data\LogInterface $log): bool;

    /**
     * Delete log by ID.
     *
     * @param int $entityId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($logId);
}
