<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2026 HOMEMADE.IO SAS
 * @date      2026-01-15
 ******************************************************************************/

declare(strict_types=1);

namespace Fastmag\Sync\Api\Service;

/**
 * Interface GenerateSimpleProductSkuInterface
 *
 * Service class which generates simple product SKU
 */
interface GenerateSimpleProductSkuInterface
{
    /**
     * Generate configurable product SKU
     *
     * @param string|null $fastmagRef
     * @param string|null $size
     * @param string|null $color
     *
     * @return string
     */
    public function execute(?string $fastmagRef = null, ?string $size = null, ?string $color = null): string;
}
