<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-19
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Rule\Taxclassfamily;

use Fastmag\Sync\Api\Rule\TaxclassfamilyRepositoryInterface as RuleRepository;
use Fastmag\Sync\Controller\Adminhtml\Rule\Taxclassfamily as ControllerAbstract;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\ForwardFactory;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\Controller\ResultInterface;

/**
 * Class NewAction
 *
 * Taxclassfamily new action
 */
class NewAction extends ControllerAbstract implements HttpGetActionInterface
{
    /** @var ForwardFactory $resultForwardFactory */
    protected $resultForwardFactory;

    /**
     * NewAction constructor
     *
     * @param Context                $context
     * @param DataPersistorInterface $dataPersistor
     * @param RuleRepository         $ruleRepository
     * @param ForwardFactory         $resultForwardFactory
     */
    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor,
        RuleRepository $ruleRepository,
        ForwardFactory $resultForwardFactory
    ) {
        parent::__construct($context, $dataPersistor, $ruleRepository);

        $this->resultForwardFactory = $resultForwardFactory;
    }

    /**
     * Create new rule
     *
     * @return ResultInterface
     */
    public function execute()
    {
        return $this->resultForwardFactory->create()->forward('edit');
    }
}
