<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-01-27
 ******************************************************************************/

namespace Fastmag\Sync\Model\Extractor\Order\Items;

use Magento\Catalog\Model\Product\Type;
use Magento\Sales\Api\Data\OrderInterface as OrderModel;
use Magento\Sales\Api\Data\OrderItemInterface as ItemModel;

/**
 * Class Extractor
 *
 * Class handling order items extraction
 */
abstract class Extractor
{
    protected OrderModel $order;

    /**
     * Extractor constructor
     *
     * @param OrderModel $order
     */
    public function __construct(OrderModel $order)
    {
        $this->order = $order;
    }

    /**
     * Get order items to sync with Fastmag
     *
     * @return ItemModel[]
     */
    public function extract(): array
    {
        $result = [];

        foreach ($this->order->getAllItems() as $item) {
            if ($item->getProductType() === Type::TYPE_SIMPLE) {
                $result[] = $item;
            }
        }

        return $result;
    }
}
