<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2026 HOMEMADE.IO SAS
 * @date      2026-01-15
 ******************************************************************************/

declare(strict_types=1);

namespace Fastmag\Sync\Process\Entity\ToMagento\Order;

use Fastmag\Sync\Process\Entity\ToMagento\Order\Creditmemo\Item as ItemEntity;
use Fastmag\Sync\Process\EntityInterface;
use Magento\Framework\DataObject;

/**
 * Class Creditmemo
 *
 * Entity class for credit memo.
 * Save and transform data from Fastmag for Magento easy integration,
 * and transfer it from hydration worker to integration worker
 *
 * @method int|null getFastmagId()
 * @method float|null getGrandTotal()
 * @method int|null getTotalQuantity()
 * @method int|null getOrderFastmagId()
 * @method int|null getOrderMagentoId()
 * @method ItemEntity[]|null getItems()
 * @method Creditmemo setFastmagId(int $fastmagId)
 * @method Creditmemo setGrandTotal(float $grandTotal)
 * @method Creditmemo setTotalQuantity(int $totalQuantity)
 * @method Creditmemo setOrderFastmagId(int $orderFastmagId)
 * @method Creditmemo setOrderMagentoId(int $orderMagentoId)
 * @method Creditmemo setItems(ItemEntity[] $items)
 */
class Creditmemo extends DataObject implements EntityInterface
{
    /**
     * Add item to the items list
     *
     * @param ItemEntity $item
     *
     * @return Creditmemo
     */
    public function addItem($item)
    {
        $items = $this->getData('items');

        $items[(string)$item->getFastmagId()] = $item;

        return $this->setData('items', $items);
    }

    /**
     * @inheritDoc
     */
    public function export()
    {
        $itemsData = [];
        if ($this->getItems() !== null && count($this->getItems()) > 0) {
            foreach ($this->getItems() as $itemId => $item) {
                $itemsData[$itemId] = $item->export();
            }
        }

        $result = [
            'fastmag_id'       => $this->getFastmagId(),
            'grand_total'      => $this->getGrandTotal(),
            'total_quantity'   => $this->getTotalQuantity(),
            'order_fastmag_id' => $this->getOrderFastmagId(),
            'order_magento_id' => $this->getOrderMagentoId(),
            'items'            => $itemsData,
        ];

        return array_filter(
            $result,
            static function ($value) {
                return $value !== null && $value !== [];
            }
        );
    }
}
