<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2026 HOMEMADE.IO SAS
 * @date      2026-01-15
 ******************************************************************************/

declare(strict_types=1);

namespace Fastmag\Sync\Process\Entity\ToMagento\Order\Creditmemo;

use Fastmag\Sync\Process\EntityInterface;
use Magento\Framework\DataObject;

/**
 * Class Item
 *
 * Entity class for credit memos' items.
 * Save and transform data from Fastmag for Magento easy integration,
 * and transfer it from hydration worker to integration worker
 *
 * @method int|null getFastmagId()
 * @method string|null getRef()
 * @method string|null getSize()
 * @method string|null getColor()
 * @method int|null getMagentoOrderItemId()
 * @method int|null getQuantity()
 * @method float|null getTotal()
 * @method Item setFastmagId(int $fastmagId)
 * @method Item setRef(string $ref)
 * @method Item setSize(string $size)
 * @method Item setColor(string $color)
 * @method Item setMagentoOrderItemId(int $magentoOrderItemId)
 * @method Item setQuantity(int $quantity)
 * @method Item setTotal(float $total)
 */
class Item extends DataObject implements EntityInterface
{
    /**
     * @inheritDoc
     */
    public function export()
    {
        $result = [
            'fastmag_id'            => $this->getFastmagId(),
            'ref'                   => $this->getRef(),
            'size'                  => $this->getSize(),
            'color'                 => $this->getColor(),
            'magento_order_item_id' => $this->getMagentoOrderItemId(),
            'quantity'              => $this->getQuantity(),
            'total'                 => $this->getTotal(),
        ];

        return array_filter(
            $result,
            static function ($value) {
                return $value !== null && $value !== [];
            }
        );
    }
}
