<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-06-19
 ******************************************************************************/

namespace Fastmag\Sync\Api;

/**
 * Interface CustomerRepositoryInterface
 */
interface CustomerRepositoryInterface
{
    /**
     * Save customer.
     *
     * @param \Fastmag\Sync\Api\Data\CustomerInterface $customer
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(\Fastmag\Sync\Api\Data\CustomerInterface $customer): \Fastmag\Sync\Api\Data\CustomerInterface;

    /**
     * Retrieve customer.
     *
     * @param int $entityId
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($entityId): \Fastmag\Sync\Api\Data\CustomerInterface;

    /**
     * Retrieve customer by Magento ID.
     *
     * @param int $magentoId
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getByMagentoId($magentoId);

    /**
     * Retrieve customer by Fastmag ID.
     *
     * @param int $fastmagId
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getByFastmagId($fastmagId);

    /**
     * Retrieve customers matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\CustomerSearchResultsInterface
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria);

    /**
     * Delete customer.
     *
     * @param \Fastmag\Sync\Api\Data\CustomerInterface $customer
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(\Fastmag\Sync\Api\Data\CustomerInterface $customer): bool;

    /**
     * Delete customer by ID.
     *
     * @param int $entityId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($entityId);
}
