<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2023 HOMEMADE.IO SAS
 * @date      2023-01-27
 ******************************************************************************/

namespace Fastmag\Sync\Model\Extractor\Order\PaymentId;

use Magento\Sales\Api\Data\OrderInterface as OrderModel;

/**
 * Class Extractor
 *
 * Class handling order payment ID extraction, depending on the payment method
 */
abstract class Extractor
{
    protected OrderModel $order;

    /**
     * Extractor constructor
     *
     * @param OrderModel $order
     */
    public function __construct(OrderModel $order)
    {
        $this->order = $order;
    }

    /**
     * Get payment ID
     *
     * @return string
     */
    public function extract(): string
    {
        $result = '';

        $payment = $this->order->getPayment();

        if ($payment !== null) {
            $result = $payment->getEntityId();

            if ($payment->getCcTransId()) {
                $result = $payment->getCcTransId();
            } elseif ($payment->getLastTransId()) {
                $result = $payment->getLastTransId();
            }
        }

        return $result;
    }
}
