<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2024 HOMEMADE.IO SAS
 * @date      2024-05-16
 ******************************************************************************/

namespace Fastmag\Sync\Process\Entity\ToFastmag\Order;

use Fastmag\Sync\Process\EntityInterface;
use Magento\Framework\DataObject;

/**
 * Class Item
 *
 * Entity class for item.
 * Save and transform data from Magento for Fastmag easy integration,
 * and transfer it from hydration worker to integration worker
 *
 * @method int|null getMagentoId()
 * @method int|null getParentItemId()
 * @method int|null getFastmagId()
 * @method string|null getSku()
 * @method string|null getName()
 * @method float|null getPriceInclTax()
 * @method float|null getDiscountPercent()
 * @method float|null getRowTotalInclTax()
 * @method string|null getFastmagBarcode()
 * @method string|null getFastmagSize()
 * @method string|null getFastmagColor()
 * @method Item setMagentoId(int $magentoId)
 * @method Item setParentItemId(int $parentItemId)
 * @method Item setFastmagId(int $fastmagId)
 * @method Item setSku(string $sku)
 * @method Item setName(string $name)
 * @method Item setPriceInclTax(float $priceInclTax)
 * @method Item setQtyOrdered(int $qtyOrdered)
 * @method Item setQtyCanceled(int $qtyCanceled)
 * @method Item setDiscountPercent(float $discountPercent)
 * @method Item setRowTotalInclTax(float $rowTotalInclTax)
 * @method Item setFastmagBarcode(string $fastmagBarcode)
 * @method Item setFastmagSize(string $fastmagSize)
 * @method Item setFastmagColor(string $fastmagColor)
 * @method Item setComment(string $comment)
 */
class Item extends DataObject implements EntityInterface
{
    /**
     * Get qty ordered
     *
     * @return float|null
     */
    public function getQtyOrdered()
    {
        return $this->getData('qty_ordered') !== null ? (float)$this->getData('qty_ordered') : null;
    }

    /**
     * Get qty canceled
     *
     * @return float|null
     */
    public function getQtyCanceled()
    {
        return $this->getData('qty_canceled') !== null ? (float)$this->getData('qty_canceled') : null;
    }

    /**
     * Get comment
     *
     * @return string|null
     */
    public function getComment()
    {
        return $this->getData('comment') ?? '';
    }

    /**
     * @inheritDoc
     */
    public function export()
    {
        $result = [
            'item_id'            => $this->getMagentoId(),
            'parent_item_id'     => $this->getParentItemId(),
            'fastmag_product_id' => $this->getFastmagId(),
            'sku'                => $this->getSku(),
            'name'               => $this->getName(),
            'qty_ordered'        => $this->getQtyOrdered(),
            'qty_canceled'       => $this->getQtyCanceled(),
            'price_incl_tax'     => $this->getPriceInclTax(),
            'discount_percent'   => $this->getDiscountPercent(),
            'row_total_incl_tax' => $this->getRowTotalInclTax(),
            'fastmag_barcode'    => $this->getFastmagBarcode(),
            'fastmag_size'       => $this->getFastmagSize(),
            'fastmag_color'      => $this->getFastmagColor(),
            'comment'            => $this->getComment()
        ];

        return array_filter(
            $result,
            static function ($value) {
                return $value !== null && $value !== [];
            }
        );
    }
}
